// Copyright 2000 Macromedia, Inc. All rights reserved.

//*************** GLOBALS *****************
var FILE_CONFIG_PATH = dw.getConfigurationPath();
var FILE_CUSTOM_SET = FILE_CONFIG_PATH + "/Menus/Custom Sets";
var PLATFORM = navigator.platform;
//******************* API **********************
function commandButtons()
{
   return new Array( BTN_OK,  "cmdOK()"
                   , BTN_Cancel, "cmdCancel()");
}

function cmdOK()
{
  var newSetName, facSetArray = new Array(), custSetArray = new Array();
  var canWrite = true,fileCopied;
  var oldFileName = MM.commandArgument[0];
  var currentShortcutList = MM.commandArgument[1]
  var oldName = currentShortcutList.shortcutListName;
  if (getExtension(oldFileName) != "xml")
    oldFileName += ".xml";
  newSetName = document.duplicateSetNameField.getAttribute("value");
  if (getExtension(newSetName) !="xml")
    newSetName += ".xml";
//  alert(newSetName);
  if (isSet(newSetName, "factory"))   // check to see if name used by factory set
  {
    alert(errMsg(MSG_NameUsedByFactorySet, newSetName));
    canWrite = false;
  }
  else if (isSet(newSetName, "custom"))
  {
    if (oldFileName == newSetName)
  {
    alert(MSG_SetNameIsTheSame);
    canWrite = false;
  }
    if (!confirm(errMsg(MSG_ShortcutSetAlreadyExists,newSetName)))
    canWrite = false;
  }
  if (canWrite)
  {
    fileCopied = currentShortcutList.writeToShortcutXML(FILE_CUSTOM_SET+"/"+newSetName);
    currentShortcutList.shortcutListName = oldName;
    if (!fileCopied)
      alert(errMsg(MSG_InvalidFileNameCannotSave, newSetName));
    else
    {
      MM.commandReturnValue = getSimpleName(newSetName);
  //  alert("global return of setName="+newSetName)
      window.close();
    }
  }
}

function cmdCancel()
{
  window.close();
}
//***************** LOCAL FUNCTIONS  ******************

function initializeUI()
{
  var origSetName; // orig Set Name should be passed in
  var newSetName;

  origSetName = MM.commandArgument[0];
  newSetName = origSetName + " "+LABEL_Copy;
  newSetName = createUniqueFilename(newSetName, FILE_CUSTOM_SET, 27);
  newSetName = newSetName.substring(newSetName.lastIndexOf("/"),newSetName.lastIndexOf(".xml"));
  document.duplicateSetNameField.setAttribute("value", newSetName);
  document.duplicateSetNameField.focus();
  document.duplicateSetNameField.select();
}

function getCustomSetList(setType)
{
  var fileObj, filterFunction;
  fileObj = new File(FILE_CUSTOM_SET);
  if (setType == "factory")
    filterFunction =  new Function("x", "return (x.isFile()) && (x.getAttributes() == 'R') && (x.getExtension()== 'xml');");
  else
    filterFunction =  new Function("x", "return (x.isFile()) && (x.getAttributes() != 'R') && (x.getExtension()== 'xml');");
  return fileObj.listFolder(filterFunction);
}

function isSet(setName, setType)
{
  var facSetArray = new Array(), i, retVal = false;
  facSetArray = getCustomSetList(setType);
  for (i=0; i<facSetArray.length; i++)
  {
    if (facSetArray[i] == setName)
  {
    retVal = true;
    break;
  }
  }
  return retVal;
}

function getExtension(fileName)
{
  var retVal = "", index;

  index = fileName.lastIndexOf(".");
  if (index != -1)
    retVal = fileName.substring(index+1);
  return retVal;
}

function getSimpleName(fileName)
{
  var index; retVal = fileName;

  index = fileName.lastIndexOf(".");
  if (index != -1)
    retVal = fileName.substring(0,index);
  return retVal;
}

function createUniqueFilename(baseName, fileDirectory, maxLength)
{
  var dupe=true,counter=1, fileObj, filterFunction, filesArray, i, fileName;
  var fileName;
  fileName = createFileName(baseName, maxLength, counter);
  fileObj = new File(fileDirectory);
  filterFunction =  new Function("x", "return (x.isFile()) && (x.getExtension().toLowerCase()=='xml');");
  filesArray = fileObj.listFolder(filterFunction);
  while (dupe==true)
  {
    dupe=false;
    fileName = createFileName(baseName, maxLength, counter++)
    for (i=0;dupe==false && i<filesArray.length;i++)
    {
      if (filesArray[i].toLowerCase()== fileName.toLowerCase())
        dupe=true;
    }
  }
  return fileName;
}

function createFileName(baseName, maxLength, counter)
{
  var fileName;
  if (baseName.length >= maxLength)
    fileName = baseName.substring(0,maxLength-counter.toString().length-1)+"~"+counter+".xml";
  else
    fileName = baseName + counter + ".xml";
  return fileName;
}